//
//  WhileAppDelegate.m
//  While
//
//  Created by Fumihiro Tezuka on 10/08/16.
//  Copyright 2010 viva Cocoa. All rights reserved.
//

#import "WhileAppDelegate.h"

@implementation WhileAppDelegate

@synthesize window;

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification {
	synthesizer = [[NSSpeechSynthesizer alloc] initWithVoice:nil];
}

- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)theApplication
{
	return YES;
}

- (IBAction)start:(id)sender
{
	/* For 文で使用する変数の宣言 */
	NSString *message;
	NSInteger times = [[numberField stringValue] integerValue];
	NSInteger menuTag = [menu selectedTag];
	
	/* For 文の本体 */
	for (int i = 0; i < 10; i++) {
		if (times == i + 1) {
			if (menuTag == 1) {
				break;
			}
			if (menuTag == 2) {
				continue;
			}
		}
		message = [NSString stringWithFormat:@"It is repeat %2d.", i + 1];
		[synthesizer startSpeakingString:message];
		[messageField setStringValue:message];
		
		/* テキスト・ビューとスピーチ・シンセサイザーでユーザーに現在の状態を伝えるための時間を確保 */
		[[NSRunLoop currentRunLoop]runUntilDate:[NSDate dateWithTimeIntervalSinceNow:2.5]];
	}
	
	/* while 文が終わったあとのユーザーへの報告 */
	if (times >= 1 && times <= 10 && menuTag != 0) {
		switch (menuTag) {
			case 1:
				message = [NSString stringWithFormat:@"It's breaking at %2d times.", times];
				break;
			case 2:
				message = [NSString stringWithFormat:@"It's skipping at %2d times.", times];
		}
	} else {
		message = @"It's complete.";
	}

	[messageField setStringValue:message];
	[synthesizer startSpeakingString:message];
}

@end
